/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.doc.signing.tool.commands;

import com.ssl.doc.signing.tool.constants.Constant;
import com.ssl.doc.signing.tool.csc.CredentialInfo;
import com.ssl.doc.signing.tool.csc.CscApi;
import com.ssl.doc.signing.tool.exception.AccessTokenException;
import com.ssl.doc.signing.tool.exception.CscApiException;
import com.ssl.doc.signing.tool.office.OfficeSignature;
import com.ssl.doc.signing.tool.pdf.PdfSignature;
import com.ssl.doc.signing.tool.pdf.PdfSignatureInfo;
import com.ssl.doc.signing.tool.util.AccessToken;
import com.ssl.doc.signing.tool.util.Paths;
import de.taimos.totp.TOTP;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Scanner;
import java.util.TimeZone;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.poifs.crypt.dsig.SignatureMethod;
import org.w3c.dom.Document;
import picocli.CommandLine;

@CommandLine.Command(name="sign", description={"Sign document"}, version={"v1.3.0"}, mixinStandardHelpOptions=true)
public class SignCommand
implements Runnable {
    private static final Logger logger = LogManager.getLogger(SignCommand.class);
    @CommandLine.Option(names={"-username"}, description={"RA username"}, required=true)
    private String username;
    @CommandLine.Option(names={"-password"}, description={"RA password"}, required=true)
    private String password;
    @CommandLine.Option(names={"-credential_id"}, description={"Credential ID"}, required=false)
    private String credentialId;
    @CommandLine.Option(names={"-input_file_path"}, description={"Path of the document to be signed"}, required=true)
    private String inputFilePath;
    @CommandLine.Option(names={"-output_dir_path"}, description={"Directory where signed document will be written"}, required=false)
    private String outputDirPath;
    @CommandLine.Option(names={"-totp_secret"}, description={"TOTP secret"}, required=false)
    private String totpSecret;
    @CommandLine.Option(names={"-signing_reason"}, description={"Signing reason"}, required=false)
    private String signingReason;
    @CommandLine.Option(names={"-signing_location"}, description={"Signing location - PDF document only"}, required=false)
    private String signingLocation;
    @CommandLine.Option(names={"-contact_info"}, description={"Contact info - PDF document only"}, required=false)
    private String contactInfo;
    @CommandLine.Option(names={"-sig_field_position"}, description={"Signature field position - PDF document only"}, required=false)
    private String sigFieldPosition;
    @CommandLine.Option(names={"-page_no"}, description={"Page number - PDF document only"}, required=false)
    private String pageNo;
    @CommandLine.Option(names={"-override"}, description={"Overrides the input file after signing, if this parameter is set and no -output_dir_path parameter"}, required=false)
    private boolean override;

    @Override
    public void run() {
        try {
            FileOutputStream fout;
            File inputFile;
            logger.info("Command: sign");
            Properties props = new Properties();
            props.load(new FileInputStream(Paths.getConfigFilePath()));
            String clientId = props.getProperty("CLIENT_ID");
            logger.info("Client ID: " + clientId);
            String oauth2Endpoint = props.getProperty("OAUTH2_ENDPOINT");
            logger.info("OAuth2 URL: " + oauth2Endpoint);
            String cscEndpoint = props.getProperty("CSC_API_ENDPOINT");
            logger.info("CSC Endpoint: " + cscEndpoint);
            String tsaUrl = props.getProperty("TSA_URL");
            logger.info("TSA URL: " + tsaUrl);
            String tsaLegacyUrl = props.getProperty("TSA_LEGACY_URL");
            logger.info("TSA Legacy URL: " + tsaLegacyUrl);
            if (this.outputDirPath == null || this.outputDirPath.equals("")) {
                if (!this.override) {
                    logger.info("'-output_directory' parameter is not set. The output signed file will replace the original file. Do you still want to continue [y/n]? ");
                    System.out.print("Warn: '-output_directory' parameter is not set. The output signed file will replace the original file. Do you still want to continue [y/n]? ");
                    Scanner sc = new Scanner(System.in);
                    String yesOrNo = sc.nextLine();
                    logger.info("User selected: " + yesOrNo);
                    if (yesOrNo.equalsIgnoreCase("n")) {
                        return;
                    }
                    if (!yesOrNo.equalsIgnoreCase("y")) {
                        System.out.print("Error: Possible value is y/n");
                        return;
                    }
                }
            } else {
                File outputDir = new File(this.outputDirPath);
                if (!outputDir.isDirectory()) {
                    logger.info("Not a valid output directory: " + this.outputDirPath);
                    System.out.print("Error: Not a valid output directory - " + this.outputDirPath);
                    return;
                }
                logger.info("Output directory path: " + outputDir);
            }
            if (!(inputFile = new File(this.inputFilePath)).exists()) {
                logger.info("Invalid input file path: " + inputFile);
                System.out.print("Error: Invalid input file path - " + inputFile);
                return;
            }
            logger.info("Input file path: " + this.inputFilePath);
            String docType = null;
            String ext = FilenameUtils.getExtension(this.inputFilePath);
            if (ext.equals("pdf")) {
                docType = "PDF";
            } else if (Constant.SUPPORTED_OFFICE_FILE_TYPES.contains(ext)) {
                docType = "Office";
            } else {
                logger.info("only PDF/DOCX/DOCM/XLSX/XLSM/PPTX/PPTM documents are allowed");
                System.out.print("Error: only PDF/DOCX/DOCM/XLSX/XLSM/PPTX/PPTM documents are allowed");
                return;
            }
            logger.info("File type: " + ext);
            logger.info("Document type: " + docType);
            AccessToken accessTokenObj = new AccessToken(clientId, this.username, this.password, oauth2Endpoint);
            String accessToken = accessTokenObj.getAccessToken();
            CscApi cscApi = new CscApi(accessToken, cscEndpoint);
            String[] credentialIds = null;
            boolean isDocSigningCert = true;
            String[] dsCredentialIds = cscApi.getCredentialIDs("DS");
            String[] esealCredentialIds = cscApi.getCredentialIDs("DS_ESEAL");
            if (this.credentialId != null && !this.credentialId.equals("")) {
                logger.info("Credential ID in input parameter: " + this.credentialId);
                List<String> credentialList = Arrays.asList(dsCredentialIds);
                if (credentialList.contains(this.credentialId)) {
                    isDocSigningCert = true;
                } else {
                    credentialList = Arrays.asList(esealCredentialIds);
                    if (credentialList.contains(this.credentialId)) {
                        isDocSigningCert = false;
                    } else {
                        logger.info("invalid credential_id in request: " + this.credentialId);
                        System.out.print("Error: Invalid credential_id in request: " + this.credentialId);
                        return;
                    }
                }
                credentialIds = new String[]{this.credentialId};
            } else {
                logger.info("No credential ID provided in input parameter");
                credentialIds = (String[])Stream.concat(Arrays.stream(dsCredentialIds), Arrays.stream(esealCredentialIds)).toArray(String[]::new);
                if (credentialIds.length == 0) {
                    logger.info("No credential ID found for this user");
                    System.out.print("Error: No credential ID found for this user");
                    return;
                }
                if (credentialIds.length > 1) {
                    System.out.println("Multiple valid credential IDs are available for this user. Please use the '-credential_id' option to designate which certificate to use for signing. Please use the 'credential_info' command to obtain more details about each credential ID");
                    System.out.println("Document Signing Credential ID(s): ");
                    for (String credId : dsCredentialIds) {
                        logger.info("Credential ID: " + credId);
                        System.out.println("- " + credId);
                    }
                    System.out.println("Document seal Credential ID(s): ");
                    for (String credId : esealCredentialIds) {
                        logger.info("Credential ID: " + credId);
                        System.out.println("- " + credId);
                    }
                    return;
                }
                if (credentialIds.length == 1 && dsCredentialIds.length == 1) {
                    isDocSigningCert = true;
                } else if (credentialIds.length == 1 && esealCredentialIds.length == 1) {
                    isDocSigningCert = false;
                }
            }
            this.credentialId = credentialIds[0];
            logger.info("Credential ID retrieved from signatures service: " + this.credentialId);
            CredentialInfo credentialInfo = cscApi.getCredentialInfo(credentialIds[0]);
            List<X509Certificate> certs = credentialInfo.getCerts();
            logger.info("Subject DN: " + certs.get(0).getSubjectDN());
            logger.info("Issuer DN: " + certs.get(0).getIssuerDN());
            logger.info("Certificate expiry: " + certs.get(0).getNotAfter());
            String signingTime = null;
            String hash = null;
            PdfSignature pdfSig = null;
            if (docType.equals("PDF")) {
                float x = -1.0f;
                float y = -1.0f;
                float width = -1.0f;
                float height = -1.0f;
                int pageNumber = -1;
                if (this.sigFieldPosition != null && this.pageNo != null) {
                    logger.info("Signature field position values: " + this.sigFieldPosition);
                    String[] sigFieldPositionArray = this.sigFieldPosition.split(",");
                    if (sigFieldPositionArray.length != 4) {
                        logger.info("Invalid signature field position value. Must be of form x, y,widhth,height");
                        System.out.print("Error: Invalid signature field position value. Must be of form x, y,widhth,height");
                        return;
                    }
                    try {
                        x = Float.parseFloat(sigFieldPositionArray[0]);
                        y = Float.parseFloat(sigFieldPositionArray[1]);
                        width = Float.parseFloat(sigFieldPositionArray[2]);
                        height = Float.parseFloat(sigFieldPositionArray[3]);
                    }
                    catch (NumberFormatException ex) {
                        logger.error("", (Throwable)ex);
                        System.out.print("Error: Format of signature field position values is not valid");
                        return;
                    }
                    try {
                        pageNumber = Integer.parseInt(this.pageNo) - 1;
                        logger.info("Page number: " + pageNumber);
                    }
                    catch (NumberFormatException ex) {
                        logger.error("", (Throwable)ex);
                        System.out.print("Error: Invalid page number format");
                        return;
                    }
                }
                long docId = new Random().nextLong();
                PdfSignatureInfo signatureInfo = new PdfSignatureInfo();
                signatureInfo.setDocumentId(docId);
                signatureInfo.setX(x);
                signatureInfo.setY(y);
                signatureInfo.setWidth(width);
                signatureInfo.setHeight(height);
                signatureInfo.setPageNo(pageNumber);
                signatureInfo.setSigningReason(this.signingReason);
                signatureInfo.setSigningLocation(this.signingLocation);
                signatureInfo.setContactInfo(this.contactInfo);
                signatureInfo.setSignDate(Calendar.getInstance());
                pdfSig = new PdfSignature(inputFile, certs);
                pdfSig.setSignatureInfo(signatureInfo);
                pdfSig.setTsaUrl(tsaUrl);
                hash = pdfSig.getHash();
            } else {
                Calendar now = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                signingTime = sdf.format(now.getTime()) + "Z";
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                Document doc = dbf.newDocumentBuilder().newDocument();
                OPCPackage container = OPCPackage.open(this.inputFilePath, PackageAccess.READ_WRITE);
                PackageRelationshipCollection dsigOriginPartTypeRelationships = container.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (dsigOriginPartTypeRelationships.size() != 0) {
                    logger.info("document already signed");
                    System.out.print("Error: document already signed");
                    container.close();
                    return;
                }
                String hashAlgo = SignatureMethod.RSA_SHA256.getHashAlgo();
                String sigAlgo = null;
                sigAlgo = credentialInfo.getSignatureAlgorithm().equals("1.2.840.10045.4.3.2") ? SignatureMethod.ECDSA_SHA256.getName() : SignatureMethod.RSA_SHA256.getName();
                OfficeSignature officeSignature = new OfficeSignature(container, doc, certs, signingTime, sigAlgo, hashAlgo, tsaLegacyUrl);
                officeSignature.setSigningReason(this.signingReason);
                hash = officeSignature.getHash();
                container.revert();
            }
            String otp = null;
            if (isDocSigningCert) {
                Scanner otpInput;
                boolean isOtpTypeOnline = cscApi.isOtpTypeOnline(this.credentialId);
                if (isOtpTypeOnline) {
                    cscApi.sendOtp(this.credentialId);
                    System.out.println("OTP sent on your registered mobile number");
                    System.out.print("Enter the OTP - Press enter to continue: ");
                    otpInput = new Scanner(System.in);
                    otp = otpInput.nextLine();
                    if (otp == null || otp.equals("")) {
                        System.out.print("Error: OTP not provided");
                        return;
                    }
                } else if (this.totpSecret == null || this.totpSecret.equals("")) {
                    System.out.print("Enter the OTP - Press enter to continue: ");
                    otpInput = new Scanner(System.in);
                    otp = otpInput.nextLine();
                    if (otp == null || otp.equals("")) {
                        System.out.print("Error: OTP not provided");
                        return;
                    }
                } else {
                    byte[] totpSeed = Base64.getDecoder().decode(this.totpSecret);
                    String hexKey = Hex.encodeHexString(totpSeed);
                    otp = TOTP.getOTP(hexKey);
                }
            } else {
                if (this.totpSecret != null) {
                    logger.info("TOTP secret must not be present for eseal");
                    System.out.print("Error: TOTP secret must not be present for eseal");
                    return;
                }
                if (otp != null) {
                    logger.info("OTP must not be present for eseal");
                    System.out.print("Error: OTP must not be present for eseal");
                    return;
                }
            }
            String[] hashes = new String[]{hash};
            String sad = cscApi.getCredentialsAuthorize(this.credentialId, 1, hashes, otp);
            String signature = cscApi.signHash(this.credentialId, sad, hashes, credentialInfo.getSignatureAlgorithm())[0];
            logger.info("Signature value: " + signature);
            byte[] signedDoc = null;
            if (docType.equals("PDF")) {
                List<List<byte[]>> revInfos = PdfSignature.getRevocationInformation(certs);
                byte[] signedTimestampedPdf = pdfSig.embedSignature(Base64.getDecoder().decode(signature), credentialInfo.getSignatureAlgorithm());
                signedDoc = PdfSignature.longTermValidation(signedTimestampedPdf, revInfos);
            } else {
                String hashAlgo = SignatureMethod.RSA_SHA256.getHashAlgo();
                String sigAlgo = null;
                sigAlgo = credentialInfo.getSignatureAlgorithm().equals("1.2.840.10045.4.3.2") ? SignatureMethod.ECDSA_SHA256.getName() : SignatureMethod.RSA_SHA256.getName();
                OPCPackage container = OPCPackage.open(this.inputFilePath, PackageAccess.READ_WRITE);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                Document doc = dbf.newDocumentBuilder().newDocument();
                OfficeSignature officeSignature = new OfficeSignature(container, doc, certs, signingTime, sigAlgo, hashAlgo, tsaLegacyUrl);
                officeSignature.setSigningReason(this.signingReason);
                signedDoc = officeSignature.sign(signature);
                container.revert();
            }
            if (this.outputDirPath != null) {
                fout = new FileOutputStream(this.outputDirPath + File.separator + inputFile.getName());
                fout.write(signedDoc);
                fout.close();
                System.out.println("Document signed successfully: " + this.outputDirPath + File.separator + inputFile.getName());
            } else {
                fout = new FileOutputStream(this.inputFilePath);
                fout.write(signedDoc);
                fout.close();
                System.out.println("Document signed successfully: " + this.inputFilePath);
            }
        }
        catch (AccessTokenException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (CscApiException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error("", (Throwable)ex);
        }
    }
}

