/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.doc.signing.tool.office;

import com.ssl.doc.signing.tool.pdf.PdfSignature;
import com.ssl.doc.signing.tool.util.AlgorithmUtils;
import com.ssl.doc.signing.tool.util.SignatureUtils;
import com.ssl.document.signing.security.DummyPrivateKey;
import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.apache.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.poifs.crypt.dsig.SignatureAlg;
import org.apache.poi.poifs.crypt.dsig.SignatureConfig;
import org.apache.poi.poifs.crypt.dsig.SignatureInfo;
import org.apache.poi.poifs.crypt.dsig.SignatureMethod;
import org.apache.poi.poifs.crypt.dsig.facets.KeyInfoSignatureFacet;
import org.apache.poi.poifs.crypt.dsig.facets.OOXMLSignatureFacet;
import org.apache.poi.poifs.crypt.dsig.facets.Office2010SignatureFacet;
import org.apache.poi.poifs.crypt.dsig.facets.SignatureFacet;
import org.apache.poi.poifs.crypt.dsig.facets.XAdESSignatureFacet;
import org.apache.poi.poifs.crypt.dsig.facets.XAdESXLSignatureFacet;
import org.apache.poi.poifs.crypt.dsig.services.RevocationData;
import org.apache.poi.poifs.crypt.dsig.services.RevocationDataService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OfficeSignature {
    private static final String XML_SIGNED_INFO = "SignedInfo";
    private static final List<Supplier<SignatureFacet>> DEFAULT_FACETS = Arrays.asList(OOXMLSignatureFacet::new, KeyInfoSignatureFacet::new, Office2010SignatureFacet::new, XAdESSignatureFacet::new, XAdESXLSignatureFacet::new);
    private OPCPackage container;
    private Document document;
    private SignatureInfo signatureInfo;
    private DOMSignContext xmlSignContext;
    private HashAlgorithm hashAlgorithm;
    private SignatureMethod signatureAlgorithm;

    public OfficeSignature(OPCPackage container, Document document, List<X509Certificate> signerCertChain, String signingTime, String signatureAlgo, String hashAlgo, String tsaUrl) throws Exception {
        this.container = container;
        this.document = document;
        SignatureConfig signatureConfig = new SignatureConfig();
        signatureConfig.setExecutionTime(signingTime);
        this.hashAlgorithm = AlgorithmUtils.findHashAlgo(hashAlgo);
        signatureConfig.setDigestAlgo(this.hashAlgorithm);
        signatureConfig.setXadesDigestAlgo(this.hashAlgorithm);
        this.signatureAlgorithm = SignatureMethod.findSignatureAlgo(signatureAlgo, hashAlgo);
        signatureConfig.setSignatureMethod(this.signatureAlgorithm);
        signatureConfig.setSigningCertificateChain(signerCertChain);
        signatureConfig.setSignatureFacets(DEFAULT_FACETS.stream().map(Supplier::get).collect(Collectors.toList()));
        signatureConfig.setKey(DummyPrivateKey.Key(signatureConfig.getSignatureMethod()));
        signatureConfig.setCommitmentType("");
        signatureConfig.setSecureValidation(false);
        signatureConfig.setTspUrl(tsaUrl);
        signatureConfig.setTspOldProtocol(false);
        signatureConfig.setIncludeEntireCertificateChain(false);
        signatureConfig.setXadesIssuerNameNoReverseOrder(false);
        this.signatureInfo = new SignatureInfo();
        this.signatureInfo.setSignatureConfig(signatureConfig);
        this.signatureInfo.setOpcPackage(container);
    }

    public void setSigningReason(String signingReason) {
        this.signatureInfo.getSignatureConfig().setSignatureDescription(signingReason);
    }

    public String getHash() throws Exception {
        this.xmlSignContext = this.signatureInfo.createXMLSignContext(this.document);
        DOMSignedInfo domSignedInfo = this.signatureInfo.preSign(this.xmlSignContext);
        Document parentDocument = (Document)this.xmlSignContext.getParent();
        NodeList sigValNode = parentDocument.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", XML_SIGNED_INFO);
        UnsynchronizedByteArrayOutputStream out = UnsynchronizedByteArrayOutputStream.builder().get();
        Element signatureElement = (Element)sigValNode.item(0);
        DOMSubTreeData subTree = new DOMSubTreeData(signatureElement, true);
        domSignedInfo.getCanonicalizationMethod().transform(subTree, this.xmlSignContext, out);
        MessageDigest md = MessageDigest.getInstance(this.hashAlgorithm.jceId);
        byte[] canonXmlBytes = md.digest(out.toByteArray());
        return Base64.getEncoder().encodeToString(canonXmlBytes);
    }

    public byte[] sign(String signatureValue) throws Exception {
        if (this.signatureAlgorithm.getName().equals(SignatureAlg.ECDSA)) {
            byte[] plainSignature = SignatureUtils.toPlainDSASignatureValue(Base64.getDecoder().decode(signatureValue));
            signatureValue = Base64.getEncoder().encodeToString(plainSignature);
        }
        List<List<byte[]>> revInfos = PdfSignature.getRevocationInformation(this.signatureInfo.getSignatureConfig().getSigningCertificateChain());
        RevocationData revocationData = new RevocationData();
        revInfos.get(1).forEach(revocationData::addOCSP);
        revInfos.get(2).forEach(revocationData::addCRL);
        RevocationDataService revocationDataService = revocationChain -> revocationData;
        this.signatureInfo.getSignatureConfig().setRevocationDataService(revocationDataService);
        this.xmlSignContext = this.signatureInfo.createXMLSignContext(this.document);
        this.signatureInfo.preSign(this.xmlSignContext);
        this.signatureInfo.postSign(this.xmlSignContext, signatureValue);
        ByteArrayOutputStream fout = new ByteArrayOutputStream();
        this.container.save(fout);
        return fout.toByteArray();
    }
}

