/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.doc.signing.tool.pdf;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.util.Matrix;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

public class PdfGraphicHelper {
    private final String name;
    private final String date;
    private String reason;
    private String location;
    private final float width;
    private final float height;
    private int attributeCounter = 0;
    private float leftFontSize;
    private final PDPageContentStream cs;
    private final PDDocument doc;
    public static final int FONTSCALE = 1000;
    private PDFont RIGHT_FONT = null;
    private PDFont LEFT_FONT = null;
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public PdfGraphicHelper(PDSignature signature, float width, float height, PDPageContentStream cs, PDDocument doc, String signerName) throws Exception {
        X500Name x500Name = new X500Name(signerName);
        RDN cn = x500Name.getRDNs(BCStyle.CN)[0];
        String name = IETFUtils.valueToString(cn.getFirst().getValue());
        this.name = "Signer: " + name;
        DATE_FORMATTER.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.date = "Date: " + DATE_FORMATTER.format(signature.getSignDate().getTime());
        this.attributeCounter = 2;
        if (Objects.nonNull(signature.getReason())) {
            ++this.attributeCounter;
            this.reason = "Reason: " + signature.getReason();
        }
        if (Objects.nonNull(signature.getLocation())) {
            ++this.attributeCounter;
            this.location = "Location: " + signature.getLocation();
        }
        this.width = width;
        this.height = height;
        this.cs = cs;
        this.doc = doc;
        PDType0Font font = PDType0Font.load(doc, new File("./fonts/GoNotoKurrent.ttf"));
        this.RIGHT_FONT = font;
        this.LEFT_FONT = font;
    }

    public PdfGraphicHelper(String name, Date date, String reason, String location, float width, float height, PDPageContentStream cs, PDDocument doc) {
        this.name = "Signer: " + name;
        DATE_FORMATTER.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.date = "Date: " + DATE_FORMATTER.format(date);
        if (Objects.nonNull(reason)) {
            this.reason = "Reason: " + reason;
        }
        if (Objects.nonNull(location)) {
            this.location = "Location: " + location;
        }
        this.width = width;
        this.height = height;
        this.cs = cs;
        this.doc = doc;
    }

    private List<String> getLinesOfRightPanel(float fontSize, int[] namePossibleBreak, int[] datePossibleBreak, int[] reasonPossibleBreak, int[] locationPossibleBreak) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getPrintLines(this.RIGHT_FONT, this.name, namePossibleBreak, fontSize, this.width / 2.0f));
        result.addAll(this.getPrintLines(this.RIGHT_FONT, this.date, datePossibleBreak, fontSize, this.width / 2.0f));
        if (Objects.nonNull(this.reason)) {
            result.addAll(this.getPrintLines(this.RIGHT_FONT, this.reason, reasonPossibleBreak, fontSize, this.width / 2.0f));
        }
        if (Objects.nonNull(this.location)) {
            result.addAll(this.getPrintLines(this.RIGHT_FONT, this.location, locationPossibleBreak, fontSize, this.width / 2.0f));
        }
        return result;
    }

    public void drawLeftPanel(String text) throws IOException {
        int[] possibleBreak = this.possibleWrapPoints(text);
        this.leftFontSize = this.getFontSizeLeft(text, possibleBreak);
        List<String> linesToShow = this.getPrintLines(this.LEFT_FONT, text, possibleBreak, this.leftFontSize, this.width / 2.0f);
        float leftLeading = this.height / (float)(linesToShow.size() + 1);
        float yOffset = this.height - leftLeading - this.leftFontSize / 3.0f;
        this.cs.beginText();
        this.cs.setFont(this.LEFT_FONT, this.leftFontSize);
        this.cs.setLeading(leftLeading);
        this.cs.setNonStrokingColor(Color.black);
        this.cs.newLineAtOffset(0.0f, yOffset);
        this.showText(linesToShow);
        this.cs.endText();
    }

    private int getFontSizeLeft(String text, int[] possibleBreak) throws IOException {
        int tmp = 0;
        float maxLength = 0.0f;
        String longestText = text;
        if (text.split("(?<=\\W)").length > 1) {
            for (int i : possibleBreak) {
                String tmpText = text.substring(tmp, i);
                float tmpWidth = this.LEFT_FONT.getStringWidth(tmpText) / 1000.0f * 10.0f;
                if (maxLength < tmpWidth) {
                    maxLength = tmpWidth;
                    longestText = tmpText;
                }
                tmp = i;
            }
        }
        int fontSize = Math.floorDiv(Math.round(1000.0f * this.width / 2.0f), Math.round(this.LEFT_FONT.getStringWidth(longestText)));
        if (this.LEFT_FONT.getFontDescriptor().getFontBoundingBox().getWidth() * (float)fontSize / 1000.0f > this.height / 2.0f) {
            fontSize = Math.floorDiv(Math.round(this.height / 2.0f), Math.round(this.LEFT_FONT.getFontDescriptor().getFontBoundingBox().getWidth() / 1000.0f));
        }
        return fontSize;
    }

    private void showText(List<String> textToShow) throws IOException {
        int i = 1;
        int lineNumber = textToShow.size();
        for (String text : textToShow) {
            this.cs.showText(text);
            if (i++ >= lineNumber) continue;
            this.cs.newLine();
        }
    }

    private List<String> getPrintLines(PDFont leftFont, String text, int[] numberOfLine, float fontSize, float paragraphWidth) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        int start = 0;
        int end = 0;
        for (int i : numberOfLine) {
            float width = leftFont.getStringWidth(text.substring(start, i)) / 1000.0f * fontSize;
            if (start < end && width > paragraphWidth) {
                lines.add(text.substring(start, end));
                start = end;
            }
            end = i;
        }
        lines.add(text.substring(start));
        return lines;
    }

    private float getFontSizeRigth(int[] namePossibleBreak, int[] datePossibleBreak, int[] reasonPossibleBreak, int[] locationPossibleBreak) throws IOException {
        float tmpWidth;
        String tmpText;
        int tmp = 0;
        float maxLength = 0.0f;
        String longestText = this.name;
        for (int i : namePossibleBreak) {
            tmpText = this.name.substring(tmp, i);
            tmpWidth = this.RIGHT_FONT.getStringWidth(tmpText) / 1000.0f * 10.0f;
            if (maxLength < tmpWidth) {
                maxLength = tmpWidth;
                longestText = tmpText;
            }
            tmp = i;
        }
        tmp = 0;
        for (int i : datePossibleBreak) {
            tmpText = this.date.substring(tmp, i);
            tmpWidth = this.RIGHT_FONT.getStringWidth(tmpText) / 1000.0f * 10.0f;
            if (maxLength < tmpWidth) {
                maxLength = tmpWidth;
                longestText = tmpText;
            }
            tmp = i;
        }
        if (Objects.nonNull(this.reason)) {
            tmp = 0;
            for (int i : reasonPossibleBreak) {
                tmpText = this.reason.substring(tmp, i);
                tmpWidth = this.RIGHT_FONT.getStringWidth(tmpText) / 1000.0f * 10.0f;
                if (maxLength < tmpWidth) {
                    maxLength = tmpWidth;
                    longestText = tmpText;
                }
                tmp = i;
            }
        }
        if (Objects.nonNull(this.location)) {
            tmp = 0;
            for (int i : locationPossibleBreak) {
                tmpText = this.location.substring(tmp, i);
                tmpWidth = this.RIGHT_FONT.getStringWidth(tmpText) / 1000.0f * 10.0f;
                if (maxLength < tmpWidth) {
                    maxLength = tmpWidth;
                    longestText = tmpText;
                }
                tmp = i;
            }
        }
        int fontSize = Math.round(1000.0f * this.width / 2.0f) / Math.round(this.RIGHT_FONT.getStringWidth(longestText));
        if (this.RIGHT_FONT.getFontDescriptor().getFontBoundingBox().getWidth() * (float)fontSize / 1000.0f > this.height / (float)(this.attributeCounter + 1)) {
            fontSize = Math.floorDiv(Math.round(this.height / (float)(this.attributeCounter + 1)), Math.round(this.RIGHT_FONT.getFontDescriptor().getFontBoundingBox().getWidth() / 1000.0f));
        }
        return fontSize;
    }

    public void drawRightPanel() throws IOException {
        int[] namePossibleBreak = this.possibleWrapPoints(this.name);
        int[] datePossibleBreak = this.possibleWrapPoints(this.date);
        int[] reasonPossibleBreak = this.possibleWrapPoints(this.reason);
        int[] locationPossibleBreak = this.possibleWrapPoints(this.location);
        float fontSize = this.getFontSizeRigth(namePossibleBreak, datePossibleBreak, reasonPossibleBreak, locationPossibleBreak);
        if (this.leftFontSize != 0.0f && this.leftFontSize / 2.0f < fontSize) {
            fontSize = this.leftFontSize / 2.0f;
        }
        List<String> linesOfRightPanel = this.getLinesOfRightPanel(fontSize, namePossibleBreak, datePossibleBreak, reasonPossibleBreak, locationPossibleBreak);
        float leading = this.height / (float)(linesOfRightPanel.size() + 1);
        float textYOffset = this.height - leading - fontSize / 3.0f;
        float textXOffset = this.width / 2.0f;
        this.cs.beginText();
        this.cs.setFont(this.RIGHT_FONT, fontSize);
        this.cs.setNonStrokingColor(Color.black);
        this.cs.newLineAtOffset(textXOffset, textYOffset);
        this.cs.setLeading(leading);
        this.showText(linesOfRightPanel);
        this.cs.endText();
    }

    public void drawBackgroundImage() throws IOException {
        String backgroundImage = "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";
        PDImageXObject img = PDImageXObject.createFromByteArray(this.doc, Base64.getDecoder().decode(backgroundImage), "");
        this.drawImg(img);
    }

    public void drawImg(PDImageXObject img) throws IOException {
        this.cs.saveGraphicsState();
        float scale = Math.min(this.width / (float)img.getWidth(), this.height / (float)img.getHeight());
        float imgXOffset = Math.abs((this.width / scale - (float)img.getWidth()) / 2.0f);
        float imgYOffset = Math.abs((this.height / scale - (float)img.getHeight()) / 2.0f);
        this.cs.transform(Matrix.getScaleInstance(scale, scale));
        this.cs.drawImage(img, imgXOffset, imgYOffset);
        this.cs.restoreGraphicsState();
    }

    private int[] possibleWrapPoints(String text) {
        if (Objects.isNull(text)) {
            return new int[0];
        }
        String[] split = text.split("(?<=\\W)");
        if (split.length <= 1) {
            split = text.split("");
        }
        int[] ret = new int[split.length];
        ret[0] = split[0].length();
        for (int i = 1; i < split.length; ++i) {
            ret[i] = ret[i - 1] + split[i].length();
        }
        return ret;
    }

    public String getName() {
        return this.name;
    }

    public String getDate() {
        return this.date;
    }

    public String getReason() {
        return this.reason;
    }

    public String getLocation() {
        return this.location;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public int getAttributeCounter() {
        return this.attributeCounter;
    }

    public float getLeftFontSize() {
        return this.leftFontSize;
    }

    public PDPageContentStream getCs() {
        return this.cs;
    }

    public PDDocument getDoc() {
        return this.doc;
    }

    public PDFont getRIGHT_FONT() {
        return this.RIGHT_FONT;
    }

    public PDFont getLEFT_FONT() {
        return this.LEFT_FONT;
    }
}

