/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.doc.signing.tool.pdf;

import com.ssl.doc.signing.tool.pdf.PdfGraphicHelper;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.util.Matrix;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

public class PdfSignatureUtils {
    private final float xOffset;
    private final float yOffset;
    private final float width;
    private final float height;
    private byte[] handSignature;

    private PDRectangle createSignatureRectangle(Rectangle2D humanRect, PDPage pdPage) {
        float x = (float)humanRect.getX();
        float y = (float)humanRect.getY();
        float width = (float)humanRect.getWidth();
        float height = (float)humanRect.getHeight();
        PDRectangle pageRect = pdPage.getCropBox();
        PDRectangle rect = new PDRectangle();
        switch (pdPage.getRotation()) {
            case 90: {
                rect.setLowerLeftY(x);
                rect.setUpperRightY(x + width);
                rect.setLowerLeftX(y);
                rect.setUpperRightX(y + height);
                break;
            }
            case 180: {
                rect.setUpperRightX(pageRect.getWidth() - x);
                rect.setLowerLeftX(pageRect.getWidth() - x - width);
                rect.setLowerLeftY(y);
                rect.setUpperRightY(y + height);
                break;
            }
            case 270: {
                rect.setLowerLeftY(pageRect.getHeight() - x - height);
                rect.setUpperRightY(pageRect.getHeight() - x);
                rect.setLowerLeftX(pageRect.getWidth() - y - width);
                rect.setUpperRightX(pageRect.getWidth() - y);
                break;
            }
            default: {
                rect.setLowerLeftX(x);
                rect.setUpperRightX(x + width);
                rect.setLowerLeftY(pageRect.getHeight() - y - height);
                rect.setUpperRightY(pageRect.getHeight() - y);
            }
        }
        return rect;
    }

    public InputStream createVisualSignatureTemplate(PDPage pdPage, PDSignature signature, String signerName) throws Exception {
        Rectangle2D.Float humanRect = new Rectangle2D.Float(this.xOffset, this.yOffset, this.width > pdPage.getMediaBox().getWidth() ? pdPage.getMediaBox().getWidth() : this.width, this.height > pdPage.getMediaBox().getHeight() ? pdPage.getMediaBox().getHeight() : this.height);
        PDRectangle rect = this.createSignatureRectangle(humanRect, pdPage);
        PDDocument doc = new PDDocument();
        PDPage page = new PDPage(pdPage.getMediaBox());
        doc.addPage(page);
        PDAcroForm acroForm = new PDAcroForm(doc);
        doc.getDocumentCatalog().setAcroForm(acroForm);
        PDSignatureField signatureField = new PDSignatureField(acroForm);
        PDAnnotationWidget widget = signatureField.getWidgets().get(0);
        List<PDField> acroFormFields = acroForm.getFields();
        acroForm.setSignaturesExist(true);
        acroForm.setAppendOnly(true);
        acroForm.getCOSObject().setDirect(true);
        acroFormFields.add(signatureField);
        widget.setRectangle(rect);
        PDStream stream = new PDStream(doc);
        PDFormXObject form = new PDFormXObject(stream);
        PDResources res = new PDResources();
        form.setResources(res);
        form.setFormType(1);
        PDRectangle bbox = new PDRectangle(rect.getWidth(), rect.getHeight());
        float bboxWidth = bbox.getWidth();
        float bboxHeight = bbox.getHeight();
        Matrix initialScale = null;
        switch (pdPage.getRotation()) {
            case 90: {
                form.setMatrix(AffineTransform.getQuadrantRotateInstance(1));
                initialScale = Matrix.getScaleInstance(bbox.getWidth() / bbox.getHeight(), bbox.getHeight() / bbox.getWidth());
                bboxHeight = bbox.getWidth();
                bboxWidth = bbox.getHeight();
                break;
            }
            case 180: {
                form.setMatrix(AffineTransform.getQuadrantRotateInstance(2));
                break;
            }
            case 270: {
                form.setMatrix(AffineTransform.getQuadrantRotateInstance(3));
                initialScale = Matrix.getScaleInstance(bbox.getWidth() / bbox.getHeight(), bbox.getHeight() / bbox.getWidth());
                bboxHeight = bbox.getWidth();
                bboxWidth = bbox.getHeight();
                break;
            }
        }
        form.setBBox(bbox);
        PDAppearanceDictionary appearance = new PDAppearanceDictionary();
        appearance.getCOSObject().setDirect(true);
        PDAppearanceStream appearanceStream = new PDAppearanceStream(form.getCOSObject());
        appearance.setNormalAppearance(appearanceStream);
        widget.setAppearance(appearance);
        PDPageContentStream cs = new PDPageContentStream(doc, appearanceStream);
        if (initialScale != null) {
            cs.transform(initialScale);
        }
        PdfGraphicHelper pdfGraphicSignature = new PdfGraphicHelper(signature, bboxWidth, bboxHeight, cs, doc, signerName);
        if (this.handSignature != null) {
            PDImageXObject img = PDImageXObject.createFromByteArray(doc, this.handSignature, "");
            pdfGraphicSignature.drawImg(img);
        } else {
            X500Name x500Name = new X500Name(signerName);
            RDN cn = x500Name.getRDNs(BCStyle.CN)[0];
            String name = IETFUtils.valueToString(cn.getFirst().getValue());
            pdfGraphicSignature.drawBackgroundImage();
            pdfGraphicSignature.drawLeftPanel(name);
            pdfGraphicSignature.drawRightPanel();
        }
        cs.close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        doc.save(baos);
        doc.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public PdfSignatureUtils(float xOffset, float yOffset, float width, float height) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.width = width;
        this.height = height;
    }

    public PdfSignatureUtils(float xOffset, float yOffset, float width, float height, byte[] handSignature) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.width = width;
        this.height = height;
        this.handSignature = handSignature;
    }
}

