/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.doc.signing.tool.commands;

import com.ssl.doc.signing.tool.csc.CredentialInfo;
import com.ssl.doc.signing.tool.csc.CscApi;
import com.ssl.doc.signing.tool.exception.CscApiException;
import com.ssl.doc.signing.tool.util.AccessToken;
import com.ssl.doc.signing.tool.util.Paths;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="get_certs", description={"Returns the certificate chain"}, version={"v1.3.0"}, mixinStandardHelpOptions=true)
public class GetCertsCommand
implements Runnable {
    private static final Logger logger = LogManager.getLogger(GetCertsCommand.class);
    @CommandLine.Option(names={"-username"}, description={"RA username"}, required=true)
    private String username;
    @CommandLine.Option(names={"-password"}, description={"RA password"}, required=true)
    private String password;
    @CommandLine.Option(names={"-credential_id"}, description={"Credential ID"}, required=true)
    private String credentialId;
    @CommandLine.Option(names={"-output_dir_path"}, description={"Directory where certificate chain will be written"}, required=true)
    private String outputDirPath;

    @Override
    public void run() {
        try {
            logger.info("Command: Get Certs");
            Properties props = new Properties();
            props.load(new FileInputStream(Paths.getConfigFilePath()));
            String clientId = props.getProperty("CLIENT_ID");
            logger.info("Client ID: " + clientId);
            String oauth2Endpoint = props.getProperty("OAUTH2_ENDPOINT");
            logger.info("OAuth2 URL: " + oauth2Endpoint);
            String cscEndpoint = props.getProperty("CSC_API_ENDPOINT");
            logger.info("CSC Endpoint: " + cscEndpoint);
            File outputDir = new File(this.outputDirPath);
            if (!outputDir.isDirectory()) {
                logger.info("Not a valid output directory: " + this.outputDirPath);
                System.out.print("Error: Not a valid output directory - " + this.outputDirPath);
                return;
            }
            logger.info("Output directory path: " + outputDir);
            AccessToken accessTokenObj = new AccessToken(clientId, this.username, this.password, oauth2Endpoint);
            String accessToken = accessTokenObj.getAccessToken();
            CscApi cscApi = new CscApi(accessToken, cscEndpoint);
            CredentialInfo credentialInfo = cscApi.getCredentialInfo(this.credentialId);
            List<X509Certificate> certs = credentialInfo.getCerts();
            for (int i = 0; i < certs.size(); ++i) {
                FileOutputStream fout = new FileOutputStream(this.outputDirPath + File.separator + i + ".cer");
                fout.write(certs.get(i).getEncoded());
                fout.close();
            }
            System.out.println("Get certificates command executed successfully. Certificate files are created at: " + this.outputDirPath);
        }
        catch (CscApiException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error("", (Throwable)ex);
        }
    }
}

