/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.dom;

import org.apache.batik.anim.dom.AbstractElement;
import org.apache.batik.anim.dom.AbstractSVGAnimatedValue;
import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.values.AnimatableStringValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedEnumeration;

public class SVGOMAnimatedEnumeration
extends AbstractSVGAnimatedValue
implements SVGAnimatedEnumeration {
    protected String[] values;
    protected short defaultValue;
    protected boolean valid;
    protected short baseVal;
    protected short animVal;
    protected boolean changing;

    public SVGOMAnimatedEnumeration(AbstractElement elt, String ns, String ln, String[] val2, short def) {
        super(elt, ns, ln);
        this.values = val2;
        this.defaultValue = def;
    }

    @Override
    public short getBaseVal() {
        if (!this.valid) {
            this.update();
        }
        return this.baseVal;
    }

    public String getBaseValAsString() {
        if (!this.valid) {
            this.update();
        }
        return this.values[this.baseVal];
    }

    protected void update() {
        String val2 = this.element.getAttributeNS(this.namespaceURI, this.localName);
        this.baseVal = val2.length() == 0 ? this.defaultValue : this.getEnumerationNumber(val2);
        this.valid = true;
    }

    protected short getEnumerationNumber(String s) {
        for (short i = 0; i < this.values.length; i = (short)(i + 1)) {
            if (!s.equals(this.values[i])) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void setBaseVal(short baseVal) throws DOMException {
        if (baseVal >= 0 && baseVal < this.values.length) {
            try {
                this.baseVal = baseVal;
                this.valid = true;
                this.changing = true;
                this.element.setAttributeNS(this.namespaceURI, this.localName, this.values[baseVal]);
            }
            finally {
                this.changing = false;
            }
        }
    }

    @Override
    public short getAnimVal() {
        if (this.hasAnimVal) {
            return this.animVal;
        }
        if (!this.valid) {
            this.update();
        }
        return this.baseVal;
    }

    public short getCheckedVal() {
        if (this.hasAnimVal) {
            return this.animVal;
        }
        if (!this.valid) {
            this.update();
        }
        if (this.baseVal == 0) {
            throw new LiveAttributeException(this.element, this.localName, 1, this.getBaseValAsString());
        }
        return this.baseVal;
    }

    @Override
    public AnimatableValue getUnderlyingValue(AnimationTarget target) {
        return new AnimatableStringValue(target, this.getBaseValAsString());
    }

    @Override
    public void attrAdded(Attr node, String newv) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    @Override
    protected void updateAnimatedValue(AnimatableValue val2) {
        if (val2 == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            this.animVal = this.getEnumerationNumber(((AnimatableStringValue)val2).getString());
            this.fireAnimatedAttributeListeners();
        }
        this.fireAnimatedAttributeListeners();
    }

    @Override
    public void attrModified(Attr node, String oldv, String newv) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    @Override
    public void attrRemoved(Attr node, String oldv) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }
}

