/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.code.signing.tool.code;

import com.ssl.code.signing.tool.file.IOvfFile;
import com.ssl.code.signing.tool.file.OvaFile;
import com.ssl.code.signing.tool.file.OvfFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class OvaSignature {
    private final IOvfFile ovFile;

    public OvaSignature(String filePath, String codeFormatType) throws IOException, NoSuchAlgorithmException {
        this.ovFile = codeFormatType.equals("ova") ? new OvaFile(filePath) : new OvfFile(filePath);
    }

    public byte[] getHash() throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(this.ovFile.toBeSignedData());
        return messageDigest.digest();
    }

    public byte[] sign(String pkcs1, List<X509Certificate> certsList) throws Exception {
        byte[] pkcs1Bytes = Base64.decodeBase64((String)pkcs1);
        this.ovFile.createSignature(pkcs1Bytes, certsList.get(0));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.ovFile.save(outputStream);
        return outputStream.toByteArray();
    }

    public void copyFiles(String inputFilePath) throws IOException {
        OvfFile ovfFile = (OvfFile)this.ovFile;
        ovfFile.copyFiles(inputFilePath);
    }
}

