/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.code.signing.tool.file;

import com.ssl.code.signing.tool.file.IOvfFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class OvfFile
implements IOvfFile {
    private final File file;
    private final String basename;
    private byte[] manifest;
    private byte[] ovf;
    private byte[] cert;
    private final Map<String, byte[]> otherResources = new HashMap<String, byte[]>();

    public OvfFile(String filename) throws IOException, NoSuchAlgorithmException {
        this.file = new File(filename);
        this.basename = FilenameUtils.getBaseName((String)filename);
        this.extractInfo();
    }

    private void extractInfo() throws IOException, NoSuchAlgorithmException {
        String fullPath = FilenameUtils.getFullPath((String)this.file.getPath());
        File manifestFile = new File(fullPath + this.basename + ".mf");
        for (Path files : this.ovaFiles(this.file.getPath())) {
            String filename = files.getFileName().toString();
            String extension = FilenameUtils.getExtension((String)filename);
            if ("ovf".equals(extension)) {
                this.ovf = FileUtils.readFileToByteArray((File)files.toFile());
                continue;
            }
            if ("mf".equals(extension)) {
                this.manifest = FileUtils.readFileToByteArray((File)files.toFile());
                manifestFile = files.toFile();
                continue;
            }
            if ("cert".equals(extension)) {
                this.cert = FileUtils.readFileToByteArray((File)files.toFile());
                continue;
            }
            this.otherResources.put(filename, FileUtils.readFileToByteArray((File)files.toFile()));
        }
        this.manifest = this.createManifest();
        IOUtils.write((byte[])this.manifest, (OutputStream)new FileOutputStream(manifestFile));
    }

    @Override
    public void save(OutputStream outputStream) throws Exception {
        IOUtils.write((byte[])this.cert, (OutputStream)outputStream);
    }

    public Set<Path> ovaFiles(String filepath) {
        String basePath = FilenameUtils.getFullPath((String)filepath);
        return Stream.of(Objects.requireNonNull(new File(basePath).listFiles())).filter(OvfFile::checkOvaFiles).map(File::toPath).collect(Collectors.toSet());
    }

    public void copyFiles(String inputFilePath) throws IOException {
        File destPath = new File(FilenameUtils.getFullPath((String)this.file.getPath()));
        for (Path srcFile : this.ovaFiles(inputFilePath)) {
            String filename = FilenameUtils.getName((String)srcFile.toString());
            File destFile = Path.of(destPath.getPath(), filename).toFile();
            if (srcFile.toFile().getCanonicalPath().equals(destFile.getCanonicalPath())) continue;
            FileUtils.copyFile((File)srcFile.toFile(), (File)destFile);
        }
    }

    private byte[] createManifest() throws NoSuchAlgorithmException {
        StringBuilder manifestFile = new StringBuilder();
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        manifestFile.append(String.format("SHA256(%s)= %s", this.basename + ".ovf", Hex.toHexString((byte[])messageDigest.digest(this.ovf))));
        manifestFile.append(System.lineSeparator());
        for (Map.Entry<String, byte[]> resourceEntry : this.otherResources.entrySet()) {
            manifestFile.append(String.format("SHA256(%s)= %s", resourceEntry.getKey(), Hex.toHexString((byte[])messageDigest.digest(resourceEntry.getValue()))));
            manifestFile.append(System.lineSeparator());
        }
        return manifestFile.toString().getBytes();
    }

    @Override
    public void createSignature(byte[] signature, X509Certificate certificate) throws CertificateEncodingException, IOException {
        String signedCertText = String.format("SHA256(%s.mf)= %s", this.basename, Hex.toHexString((byte[])signature)) + System.lineSeparator() + this.convertCertificateToPem(certificate.getEncoded());
        this.setCert(signedCertText.getBytes());
    }

    @Override
    public byte[] toBeSignedData() {
        return this.manifest;
    }

    private void setCert(byte[] cert) {
        this.cert = cert;
    }

    private String convertCertificateToPem(byte[] x509Cert) throws IOException {
        PemObject pemObject = new PemObject("CERTIFICATE", x509Cert);
        StringWriter sw = new StringWriter();
        try (PemWriter pw = new PemWriter((Writer)sw);){
            pw.writeObject((PemObjectGenerator)pemObject);
        }
        return sw.toString();
    }

    public static FilenameFilter ignoreFiles() {
        return (dir, name) -> {
            String extension = FilenameUtils.getExtension((String)name);
            return !OVF_REQUIRED_FILE_EXTENSIONS.contains(extension);
        };
    }

    private static boolean checkOvaFiles(File file) {
        String fileExtension = FilenameUtils.getExtension((String)file.getName());
        return OVF_REQUIRED_FILE_EXTENSIONS.contains(fileExtension) || "ovf".equals(fileExtension);
    }
}

