/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.code.signing.tool.code;

import com.ssl.code.signing.tool.http.HTTPClient;
import java.io.File;
import java.math.BigInteger;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.asn1.authenticode.SpcSpOpusInfo;
import net.jsign.asn1.authenticode.SpcStatementType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;

public class CatSignature {
    public byte[] getHash(String filePath, String programName) throws Exception {
        File file = new File(filePath);
        byte[] data = Files.readAllBytes(file.toPath());
        CMSSignedData signedData = new CMSSignedData(data);
        ASN1Sequence contentSequence = (ASN1Sequence)signedData.getSignedContent().getContent();
        byte[] contentToSign = contentSequence.getEncoded();
        AlgorithmIdentifier digestAlgId = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, (ASN1Encodable)DERNull.INSTANCE);
        DigestCalculator delegate = new JcaDigestCalculatorProviderBuilder().build().get(digestAlgId);
        ASN1InputStream in = new ASN1InputStream(contentToSign);
        ASN1Sequence sequence = (ASN1Sequence)in.readObject();
        for (ASN1Encodable element : sequence) {
            delegate.getOutputStream().write(element.toASN1Primitive().getEncoded());
        }
        byte[] contentDigest = delegate.getDigest();
        ASN1EncodableVector signedAttributesVector = new ASN1EncodableVector();
        signedAttributesVector.add((ASN1Encodable)new Attribute(PKCSObjectIdentifiers.pkcs_9_at_contentType, (ASN1Set)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier("1.3.6.1.4.1.311.10.1"))));
        SpcStatementType spcStatementType = new SpcStatementType(AuthenticodeObjectIdentifiers.SPC_INDIVIDUAL_SP_KEY_PURPOSE_OBJID);
        signedAttributesVector.add((ASN1Encodable)new Attribute(AuthenticodeObjectIdentifiers.SPC_STATEMENT_TYPE_OBJID, (ASN1Set)new DERSet((ASN1Encodable)spcStatementType)));
        signedAttributesVector.add((ASN1Encodable)new Attribute(PKCSObjectIdentifiers.pkcs_9_at_messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(contentDigest))));
        SpcSpOpusInfo spcSpOpusInfo = new SpcSpOpusInfo(programName, "");
        signedAttributesVector.add((ASN1Encodable)new Attribute(AuthenticodeObjectIdentifiers.SPC_SP_OPUS_INFO_OBJID, (ASN1Set)new DERSet((ASN1Encodable)spcSpOpusInfo)));
        DERSet signedAttributes = new DERSet(signedAttributesVector);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(signedAttributes.getEncoded());
        byte[] hashToSign = messageDigest.digest();
        return hashToSign;
    }

    public byte[] sign(String pkcs1, File filePath, String tsaURL, List<X509Certificate> certsList, String programName) throws Exception {
        byte[] data = Files.readAllBytes(filePath.toPath());
        CMSSignedData signedData = new CMSSignedData(data);
        ASN1Sequence contentSequence = (ASN1Sequence)signedData.getSignedContent().getContent();
        byte[] contentToSign = contentSequence.getEncoded();
        AlgorithmIdentifier digestAlgId = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, (ASN1Encodable)DERNull.INSTANCE);
        AlgorithmIdentifier signatureOid = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha256WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE);
        DigestCalculator delegate = new JcaDigestCalculatorProviderBuilder().build().get(digestAlgId);
        ASN1InputStream in = new ASN1InputStream(contentToSign);
        ASN1Sequence sequence = (ASN1Sequence)in.readObject();
        for (ASN1Encodable element : sequence) {
            delegate.getOutputStream().write(element.toASN1Primitive().getEncoded());
        }
        byte[] contentDigest = delegate.getDigest();
        ASN1EncodableVector signedAttributesVector = new ASN1EncodableVector();
        signedAttributesVector.add((ASN1Encodable)new Attribute(PKCSObjectIdentifiers.pkcs_9_at_contentType, (ASN1Set)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier("1.3.6.1.4.1.311.10.1"))));
        SpcStatementType spcStatementType = new SpcStatementType(AuthenticodeObjectIdentifiers.SPC_INDIVIDUAL_SP_KEY_PURPOSE_OBJID);
        signedAttributesVector.add((ASN1Encodable)new Attribute(AuthenticodeObjectIdentifiers.SPC_STATEMENT_TYPE_OBJID, (ASN1Set)new DERSet((ASN1Encodable)spcStatementType)));
        signedAttributesVector.add((ASN1Encodable)new Attribute(PKCSObjectIdentifiers.pkcs_9_at_messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(contentDigest))));
        SpcSpOpusInfo spcSpOpusInfo = new SpcSpOpusInfo(programName, "");
        signedAttributesVector.add((ASN1Encodable)new Attribute(AuthenticodeObjectIdentifiers.SPC_SP_OPUS_INFO_OBJID, (ASN1Set)new DERSet((ASN1Encodable)spcSpOpusInfo)));
        DERSet signedAttributes = new DERSet(signedAttributesVector);
        byte[] pkcs1SigBytes = Base64.getDecoder().decode(pkcs1);
        ASN1EncodableVector unSignedAttributesVector = new ASN1EncodableVector();
        unSignedAttributesVector.add((ASN1Encodable)new Attribute(AuthenticodeObjectIdentifiers.SPC_RFC3161_OBJID, (ASN1Set)new DERSet((ASN1Encodable)ASN1Primitive.fromByteArray((byte[])this.signatureTimestamp(pkcs1SigBytes, tsaURL)))));
        DERSet unSignedAttributes = new DERSet(unSignedAttributesVector);
        Certificate signerCert = Certificate.getInstance((Object)certsList.get(0).getEncoded());
        SignerInfo signerInfo = new SignerInfo(new SignerIdentifier(new IssuerAndSerialNumber(signerCert)), digestAlgId, (ASN1Set)signedAttributes, signatureOid, (ASN1OctetString)new DEROctetString(pkcs1SigBytes), (ASN1Set)unSignedAttributes);
        ASN1EncodableVector digestAlgorithmsVector = new ASN1EncodableVector();
        digestAlgorithmsVector.add((ASN1Encodable)digestAlgId);
        ASN1EncodableVector certificatesVector = new ASN1EncodableVector();
        for (java.security.cert.Certificate certificate : certsList) {
            certificatesVector.add((ASN1Encodable)Certificate.getInstance((Object)certificate.getEncoded()));
        }
        ASN1InputStream asn1InputStream = new ASN1InputStream(contentToSign);
        ContentInfo contentInfo = new ContentInfo(new ASN1ObjectIdentifier("1.3.6.1.4.1.311.10.1"), (ASN1Encodable)asn1InputStream.readObject());
        ASN1EncodableVector authenticodeSignedData = new ASN1EncodableVector();
        authenticodeSignedData.add((ASN1Encodable)new ASN1Integer(1L));
        authenticodeSignedData.add((ASN1Encodable)new DERSet(digestAlgorithmsVector));
        authenticodeSignedData.add((ASN1Encodable)contentInfo);
        authenticodeSignedData.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)new DERSet(certificatesVector)));
        authenticodeSignedData.add((ASN1Encodable)new DERSet((ASN1Encodable)signerInfo));
        ContentInfo contentInfo2 = new ContentInfo(PKCSObjectIdentifiers.signedData, (ASN1Encodable)new DERSequence(authenticodeSignedData));
        byte[] pkcs7 = contentInfo2.getEncoded("DER");
        return pkcs7;
    }

    private byte[] signatureTimestamp(byte[] pkcs1Signature, String tsaUrl) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(pkcs1Signature);
        byte[] messageImprint = md.digest();
        TimeStampRequestGenerator tsqGenerator = new TimeStampRequestGenerator();
        tsqGenerator.setCertReq(true);
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        TimeStampRequest request = tsqGenerator.generate(new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.1"), messageImprint, nonce);
        byte[] tspRequestBytes = request.getEncoded();
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("content-type", "application/timestamp-query");
        HTTPClient client = new HTTPClient(tsaUrl, reqHeaders);
        client.sendPOSTRequest(tspRequestBytes);
        byte[] timestampRes = client.getBody();
        TimeStampResponse response = new TimeStampResponse(timestampRes);
        response.validate(request);
        TimeStampToken token = response.getTimeStampToken();
        return token.getEncoded();
    }
}

