/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.code.signing.tool.code;

import com.sun.jarsigner.ContentSigner;
import com.sun.jarsigner.ContentSignerParameters;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import sun.security.tools.PathList;
import sun.security.tools.jarsigner.TimestampedSigner;
import sun.security.util.ManifestDigester;
import sun.security.util.SignatureFileVerifier;
import sun.security.x509.AlgorithmId;

public class JarSignature {
    private static final String META_INF = "META-INF/";

    public byte[] getHash(String filePath) throws Exception {
        MessageDigest[] digests;
        JarFile zipFile = new JarFile(filePath);
        String[] digestalg = new String[]{"SHA-256"};
        try {
            digests = new MessageDigest[digestalg.length];
            for (int i = 0; i < digestalg.length; ++i) {
                digests[i] = MessageDigest.getInstance(digestalg[i]);
            }
        }
        catch (NoSuchAlgorithmException asae) {
            throw new AssertionError((Object)asae);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bout);
        ZipOutputStream zos = new ZipOutputStream(ps);
        Manifest manifest = new Manifest();
        Map<String, Attributes> mfEntries = manifest.getEntries();
        Attributes oldAttr = null;
        boolean mfModified = false;
        boolean mfCreated = false;
        byte[] mfRawBytes = null;
        ZipEntry mfFile = this.getManifestFile(zipFile);
        if (mfFile != null) {
            mfRawBytes = ((ZipFile)zipFile).getInputStream(mfFile).readAllBytes();
            manifest.read(new ByteArrayInputStream(mfRawBytes));
            oldAttr = (Attributes)manifest.getMainAttributes().clone();
        } else {
            Attributes mattr = manifest.getMainAttributes();
            mattr.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            String javaVendor = System.getProperty("java.vendor");
            String jdkVersion = System.getProperty("java.version");
            mattr.putValue("Created-By", jdkVersion + " (" + javaVendor + ")");
            mfFile = new ZipEntry("META-INF/MANIFEST.MF");
            mfCreated = true;
        }
        Vector<ZipEntry> mfFiles = new Vector<ZipEntry>();
        boolean wasSigned = false;
        Enumeration<? extends ZipEntry> enum_ = ((ZipFile)zipFile).entries();
        while (enum_.hasMoreElements()) {
            ZipEntry ze = enum_.nextElement();
            if (ze.getName().startsWith(META_INF)) {
                mfFiles.addElement(ze);
                if (SignatureFileVerifier.isBlockOrSF(ze.getName().toUpperCase(Locale.ENGLISH))) {
                    wasSigned = true;
                }
                if (SignatureFileVerifier.isSigningRelated(ze.getName())) continue;
            }
            if (manifest.getAttributes(ze.getName()) != null) {
                if (!this.updateDigests(ze, zipFile, digests, manifest)) continue;
                mfModified = true;
                continue;
            }
            if (ze.isDirectory()) continue;
            Attributes attrs = this.getDigestAttributes(ze, zipFile, digests);
            mfEntries.put(ze.getName(), attrs);
            mfModified = true;
        }
        if (mfModified) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            manifest.write(baos);
            if (wasSigned) {
                byte[] newBytes = baos.toByteArray();
                if (mfRawBytes != null && oldAttr.equals(manifest.getMainAttributes())) {
                    int oldPos;
                    int newPos = this.findHeaderEnd(newBytes);
                    if (newPos == (oldPos = this.findHeaderEnd(mfRawBytes))) {
                        System.arraycopy(mfRawBytes, 0, newBytes, 0, oldPos);
                    } else {
                        byte[] lastBytes = new byte[oldPos + newBytes.length - newPos];
                        System.arraycopy(mfRawBytes, 0, lastBytes, 0, oldPos);
                        System.arraycopy(newBytes, newPos, lastBytes, oldPos, newBytes.length - newPos);
                        newBytes = lastBytes;
                    }
                }
                mfRawBytes = newBytes;
            } else {
                mfRawBytes = baos.toByteArray();
            }
        }
        if (mfModified) {
            mfFile = new ZipEntry("META-INF/MANIFEST.MF");
        }
        zos.putNextEntry(mfFile);
        zos.write(mfRawBytes);
        ManifestDigester manDig = new ManifestDigester(mfRawBytes);
        SignatureFile sf = new SignatureFile(digests, manifest, manDig, "CERT", true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        sf.write(baos);
        byte[] content = baos.toByteArray();
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(content);
        return md.digest();
    }

    public byte[] sign(String pkcs1, String filePath, String tsaURL, X509Certificate[] chain) throws Exception {
        ZipEntry ze;
        MessageDigest[] digests;
        ZipFile zipFile = new ZipFile(filePath);
        byte[] signature = Base64.getDecoder().decode(pkcs1);
        String[] digestalg = new String[]{"SHA-256"};
        try {
            digests = new MessageDigest[digestalg.length];
            for (int i = 0; i < digestalg.length; ++i) {
                digests[i] = MessageDigest.getInstance(digestalg[i]);
            }
        }
        catch (NoSuchAlgorithmException asae) {
            throw new AssertionError((Object)asae);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bout);
        ZipOutputStream zos = new ZipOutputStream(ps);
        Manifest manifest = new Manifest();
        Map<String, Attributes> mfEntries = manifest.getEntries();
        Attributes oldAttr = null;
        boolean mfModified = false;
        boolean mfCreated = false;
        byte[] mfRawBytes = null;
        ZipEntry mfFile = this.getManifestFile(zipFile);
        if (mfFile != null) {
            mfRawBytes = zipFile.getInputStream(mfFile).readAllBytes();
            manifest.read(new ByteArrayInputStream(mfRawBytes));
            oldAttr = (Attributes)manifest.getMainAttributes().clone();
        } else {
            Attributes mattr = manifest.getMainAttributes();
            mattr.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            String javaVendor = System.getProperty("java.vendor");
            String jdkVersion = System.getProperty("java.version");
            mattr.putValue("Created-By", jdkVersion + " (" + javaVendor + ")");
            mfFile = new ZipEntry("META-INF/MANIFEST.MF");
            mfCreated = true;
        }
        Vector<ZipEntry> mfFiles = new Vector<ZipEntry>();
        boolean wasSigned = false;
        Enumeration<? extends ZipEntry> enum_ = zipFile.entries();
        while (enum_.hasMoreElements()) {
            ZipEntry ze2 = enum_.nextElement();
            if (ze2.getName().startsWith(META_INF)) {
                mfFiles.addElement(ze2);
                if (SignatureFileVerifier.isBlockOrSF(ze2.getName().toUpperCase(Locale.ENGLISH))) {
                    wasSigned = true;
                }
                if (SignatureFileVerifier.isSigningRelated(ze2.getName())) continue;
            }
            if (manifest.getAttributes(ze2.getName()) != null) {
                if (!this.updateDigests(ze2, zipFile, digests, manifest)) continue;
                mfModified = true;
                continue;
            }
            if (ze2.isDirectory()) continue;
            Attributes attrs = this.getDigestAttributes(ze2, zipFile, digests);
            mfEntries.put(ze2.getName(), attrs);
            mfModified = true;
        }
        if (mfModified) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            manifest.write(baos);
            if (wasSigned) {
                byte[] newBytes = baos.toByteArray();
                if (mfRawBytes != null && oldAttr.equals(manifest.getMainAttributes())) {
                    int oldPos;
                    int newPos = this.findHeaderEnd(newBytes);
                    if (newPos == (oldPos = this.findHeaderEnd(mfRawBytes))) {
                        System.arraycopy(mfRawBytes, 0, newBytes, 0, oldPos);
                    } else {
                        byte[] lastBytes = new byte[oldPos + newBytes.length - newPos];
                        System.arraycopy(mfRawBytes, 0, lastBytes, 0, oldPos);
                        System.arraycopy(newBytes, newPos, lastBytes, oldPos, newBytes.length - newPos);
                        newBytes = lastBytes;
                    }
                }
                mfRawBytes = newBytes;
            } else {
                mfRawBytes = baos.toByteArray();
            }
        }
        if (mfModified) {
            mfFile = new ZipEntry("META-INF/MANIFEST.MF");
        }
        zos.putNextEntry(mfFile);
        zos.write(mfRawBytes);
        ManifestDigester manDig = new ManifestDigester(mfRawBytes);
        SignatureFile sf = new SignatureFile(digests, manifest, manDig, "CERT", true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        sf.write(baos);
        byte[] content = baos.toByteArray();
        ContentSigner signingMechanism = null;
        boolean externalSF = true;
        JarSignerParameters params = new JarSignerParameters(null, new URI(tsaURL), null, "SHA-256", signature, "SHA256WithRSA", chain, content, zipFile);
        byte[] block = sf.generateBlock(params, externalSF, signingMechanism);
        String sfFilename = sf.getMetaName();
        String bkFilename = sf.getBlockName("RSA");
        ZipEntry sfFile = new ZipEntry(sfFilename);
        ZipEntry bkFile = new ZipEntry(bkFilename);
        long time = System.currentTimeMillis();
        sfFile.setTime(time);
        bkFile.setTime(time);
        zos.putNextEntry(sfFile);
        sf.write(zos);
        zos.putNextEntry(bkFile);
        zos.write(block);
        for (int i = 0; i < mfFiles.size(); ++i) {
            ze = (ZipEntry)mfFiles.elementAt(i);
            if (ze.getName().equalsIgnoreCase("META-INF/MANIFEST.MF") || ze.getName().equalsIgnoreCase(sfFilename) || ze.getName().equalsIgnoreCase(bkFilename)) continue;
            this.writeEntry(zipFile, zos, ze);
        }
        Enumeration<? extends ZipEntry> enum_2 = zipFile.entries();
        while (enum_2.hasMoreElements()) {
            ze = enum_2.nextElement();
            if (ze.getName().startsWith(META_INF)) continue;
            this.writeEntry(zipFile, zos, ze);
        }
        zipFile.close();
        zos.close();
        return bout.toByteArray();
    }

    private void writeEntry(ZipFile zf, ZipOutputStream os, ZipEntry ze) throws IOException {
        ZipEntry ze2 = new ZipEntry(ze.getName());
        ze2.setMethod(ze.getMethod());
        ze2.setTime(ze.getTime());
        ze2.setComment(ze.getComment());
        ze2.setExtra(ze.getExtra());
        if (ze.getMethod() == 0) {
            ze2.setSize(ze.getSize());
            ze2.setCrc(ze.getCrc());
        }
        os.putNextEntry(ze2);
        this.writeBytes(zf, ze, os);
    }

    private void writeBytes(ZipFile zf, ZipEntry ze, ZipOutputStream os) throws IOException {
        try (InputStream is = zf.getInputStream(ze);){
            is.transferTo(os);
        }
    }

    private boolean updateDigests(ZipEntry ze, ZipFile zf, MessageDigest[] digests, Manifest mf) throws IOException {
        boolean update = false;
        Attributes attrs = mf.getAttributes(ze.getName());
        String[] base64Digests = this.getDigests(ze, zf, digests);
        for (int i = 0; i < digests.length; ++i) {
            Object name = null;
            try {
                AlgorithmId aid = AlgorithmId.get(digests[i].getAlgorithm());
                for (Object key : attrs.keySet()) {
                    String tmp;
                    String n;
                    if (!(key instanceof Attributes.Name) || !(n = key.toString()).toUpperCase(Locale.ENGLISH).endsWith("-DIGEST") || !AlgorithmId.get(tmp = n.substring(0, n.length() - 7)).equals(aid)) continue;
                    name = n;
                    break;
                }
            }
            catch (NoSuchAlgorithmException aid) {
                // empty catch block
            }
            if (name == null) {
                name = digests[i].getAlgorithm() + "-Digest";
                attrs.putValue((String)name, base64Digests[i]);
                update = true;
                continue;
            }
            String mfDigest = attrs.getValue((String)name);
            if (mfDigest.equalsIgnoreCase(base64Digests[i])) continue;
            attrs.putValue((String)name, base64Digests[i]);
            update = true;
        }
        return update;
    }

    private Attributes getDigestAttributes(ZipEntry ze, ZipFile zf, MessageDigest[] digests) throws IOException {
        String[] base64Digests = this.getDigests(ze, zf, digests);
        Attributes attrs = new Attributes();
        for (int i = 0; i < digests.length; ++i) {
            attrs.putValue(digests[i].getAlgorithm() + "-Digest", base64Digests[i]);
        }
        return attrs;
    }

    private ZipEntry getManifestFile(ZipFile zf) {
        ZipEntry ze = zf.getEntry("META-INF/MANIFEST.MF");
        if (ze == null) {
            Enumeration<? extends ZipEntry> enum_ = zf.entries();
            while (enum_.hasMoreElements() && ze == null) {
                ze = enum_.nextElement();
                if ("META-INF/MANIFEST.MF".equalsIgnoreCase(ze.getName())) continue;
                ze = null;
            }
        }
        return ze;
    }

    private String[] getDigests(ZipEntry ze, ZipFile zf, MessageDigest[] digests) throws IOException {
        int i;
        try (InputStream is = zf.getInputStream(ze);){
            int n;
            byte[] buffer = new byte[8192];
            for (long left = ze.getSize(); left > 0L && (n = is.read(buffer, 0, buffer.length)) != -1; left -= (long)n) {
                for (i = 0; i < digests.length; ++i) {
                    digests[i].update(buffer, 0, n);
                }
            }
        }
        String[] base64Digests = new String[digests.length];
        for (i = 0; i < digests.length; ++i) {
            base64Digests[i] = Base64.getEncoder().encodeToString(digests[i].digest());
        }
        return base64Digests;
    }

    private int findHeaderEnd(byte[] bs) {
        boolean newline = true;
        int len = bs.length;
        block4: for (int i = 0; i < len; ++i) {
            switch (bs[i]) {
                case 13: {
                    if (i < len - 1 && bs[i + 1] == 10) {
                        ++i;
                    }
                }
                case 10: {
                    if (newline) {
                        return i + 1;
                    }
                    newline = true;
                    continue block4;
                }
                default: {
                    newline = false;
                }
            }
        }
        return len;
    }

    private ContentSigner loadSigningMechanism(String signerClassName, String signerClassPath) {
        String cpString = PathList.appendPath(System.getProperty("env.class.path"), null);
        cpString = PathList.appendPath(System.getProperty("java.class.path"), cpString);
        cpString = PathList.appendPath(signerClassPath, cpString);
        URL[] urls = PathList.pathToURLs(cpString);
        URLClassLoader appClassLoader = new URLClassLoader(urls);
        try {
            Class<?> signerClass = appClassLoader.loadClass(signerClassName);
            Object signer = signerClass.newInstance();
            return (ContentSigner)signer;
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Invalid altSigner or altSignerPath", e);
        }
    }

    class JarSignerParameters
    implements ContentSignerParameters {
        private String[] args;
        private URI tsa;
        private byte[] signature;
        private String signatureAlgorithm;
        private X509Certificate[] signerCertificateChain;
        private byte[] content;
        private ZipFile source;
        private String tSAPolicyID;
        private String tSADigestAlg;

        JarSignerParameters(String[] args, URI tsa, String tSAPolicyID, String tSADigestAlg, byte[] signature, String signatureAlgorithm, X509Certificate[] signerCertificateChain, byte[] content, ZipFile source) {
            Objects.requireNonNull(signature);
            Objects.requireNonNull(signatureAlgorithm);
            Objects.requireNonNull(signerCertificateChain);
            this.args = args;
            this.tsa = tsa;
            this.tSAPolicyID = tSAPolicyID;
            this.tSADigestAlg = tSADigestAlg;
            this.signature = signature;
            this.signatureAlgorithm = signatureAlgorithm;
            this.signerCertificateChain = signerCertificateChain;
            this.content = content;
            this.source = source;
        }

        public String[] getCommandLine() {
            return this.args;
        }

        public URI getTimestampingAuthority() {
            return this.tsa;
        }

        public X509Certificate getTimestampingAuthorityCertificate() {
            return null;
        }

        public String getTSAPolicyID() {
            return this.tSAPolicyID;
        }

        public String getTSADigestAlg() {
            return this.tSADigestAlg;
        }

        public byte[] getSignature() {
            return this.signature;
        }

        public String getSignatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        public X509Certificate[] getSignerCertificateChain() {
            return this.signerCertificateChain;
        }

        public byte[] getContent() {
            return this.content;
        }

        public ZipFile getSource() {
            return this.source;
        }
    }

    static class SignatureFile {
        Manifest sf;
        String baseName;

        public SignatureFile(MessageDigest[] digests, Manifest mf, ManifestDigester md, String baseName, boolean signManifest) {
            ManifestDigester.Entry mde;
            this.baseName = baseName;
            String version = System.getProperty("java.version");
            String javaVendor = System.getProperty("java.vendor");
            this.sf = new Manifest();
            Attributes mattr = this.sf.getMainAttributes();
            mattr.putValue(Attributes.Name.SIGNATURE_VERSION.toString(), "1.0");
            mattr.putValue("Created-By", version + " (" + javaVendor + ")");
            if (signManifest) {
                for (MessageDigest digest : digests) {
                    mattr.putValue(digest.getAlgorithm() + "-Digest-Manifest", Base64.getEncoder().encodeToString(md.manifestDigest(digest)));
                }
            }
            if ((mde = md.get("Manifest-Main-Attributes", false)) != null) {
                for (MessageDigest digest : digests) {
                    mattr.putValue(digest.getAlgorithm() + "-Digest-Manifest-Main-Attributes", Base64.getEncoder().encodeToString(mde.digest(digest)));
                }
            } else {
                throw new IllegalStateException("ManifestDigester failed to create Manifest-Main-Attribute entry");
            }
            Map<String, Attributes> entries = this.sf.getEntries();
            for (String name : mf.getEntries().keySet()) {
                mde = md.get(name, false);
                if (mde == null) continue;
                Attributes attr = new Attributes();
                for (MessageDigest digest : digests) {
                    attr.putValue(digest.getAlgorithm() + "-Digest", Base64.getEncoder().encodeToString(mde.digest(digest)));
                }
                entries.put(name, attr);
            }
        }

        public void write(OutputStream out) throws IOException {
            this.sf.write(out);
        }

        public String getMetaName() {
            return JarSignature.META_INF + this.baseName + ".SF";
        }

        public String getBlockName(String keyAlgorithm) {
            return JarSignature.META_INF + this.baseName + "." + keyAlgorithm;
        }

        public byte[] generateBlock(ContentSignerParameters params, boolean externalSF, ContentSigner signingMechanism) throws NoSuchAlgorithmException, IOException, CertificateException {
            if (signingMechanism == null) {
                signingMechanism = new TimestampedSigner();
            }
            return signingMechanism.generateSignedData(params, externalSF, params.getTimestampingAuthority() != null || params.getTimestampingAuthorityCertificate() != null);
        }
    }
}

